// =============================
// File: /public/admin/license_form.php (Create/Update)
// =============================
<?php
require_once __DIR__ . '/../../lib/db.php';
require_once __DIR__ . '/../../lib/functions.php';
$pdo = db();


$id = (int)($_GET['id'] ?? 0);
$editing = $id > 0;


if ($_SERVER['REQUEST_METHOD'] === 'POST') {
if (!csrf_verify()) die('Invalid CSRF token');
$data = [
'license_no' => trim($_POST['license_no'] ?? ''),
'trade_name' => trim($_POST['trade_name'] ?? ''),
'owner_name' => trim($_POST['owner_name'] ?? ''),
'business_address' => trim($_POST['business_address'] ?? ''),
'zone_id' => (int)($_POST['zone_id'] ?? 0),
'issue_date' => $_POST['issue_date'] ?: null,
'expiry_date' => $_POST['expiry_date'] ?: null,
'fee_amount' => (float)($_POST['fee_amount'] ?? 0),
'status' => $_POST['status'] ?? 'Active',
'remarks' => trim($_POST['remarks'] ?? ''),
];


if ($editing) {
$sql = 'UPDATE licenses SET license_no=?, trade_name=?, owner_name=?, business_address=?, zone_id=?, issue_date=?, expiry_date=?, fee_amount=?, status=?, remarks=? WHERE id=?';
$params = [...array_values($data), $id];
} else {
$sql = 'INSERT INTO licenses (license_no, trade_name, owner_name, business_address, zone_id, issue_date, expiry_date, fee_amount, status, remarks) VALUES (?,?,?,?,?,?,?,?,?,?)';
$params = array_values($data);
}
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
flash('ok', $editing ? 'License updated.' : 'License created.');
redirect('licenses.php');
}


$zones = $pdo->query('SELECT id, name FROM zones ORDER BY name')->fetchAll();
$item = [
'license_no' => '', 'trade_name' => '', 'owner_name' => '', 'business_address' => '',
'zone_id' => '', 'issue_date' => '', 'expiry_date' => '', 'fee_amount' => '', 'status' => 'Active', 'remarks' => ''
];


if ($editing) {
$stmt = $pdo->prepare('SELECT * FROM licenses WHERE id = ?');
$stmt->execute([$id]);
$item = $stmt->fetch() ?: $item;
}


include __DIR__ . '/../../partials/header.php';
?>
<section class="card">
<h2><?= $editing ? 'Edit License' : 'New License' ?></h2>
<form method="post">
<input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
<div class="row">
<div>
<label class="label">License ID</label>
<input class="input" name="license_no" required value="<?= e($item['license_no']) ?>">
</div>
<div>
<label class="label">Zone</label>
<?php include __DIR__ . '/../../partials/footer.php'; ?>